% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse_dense.R
\name{sparse_or_dense}
\alias{sparse_or_dense}
\title{Test for sparse against dense topologies}
\usage{
sparse_or_dense(x, type, ...)
}
\arguments{
\item{x}{An n x p matrix or dataframe containing the variables for n independent observations on p variables.}

\item{type}{What is the data type? Options: currently only binary and ordinal are supported}

\item{...}{additional arguments of the bgms function}
}
\value{
List containing results of the analysis:

\itemize{

\item \code{log.BF} The log of the Bayes factor of the test of a sparse against a dense network structure. A value larger 0 indicates evidence for a sparse structure. Contrarily, a value smaller 0 indicates evidence for a dense structure.

\item \code{BF} The Bayes factor of the test of a sparse against a dense network structure. A value larger 1 indicates evidence for a sparse structure. Contrarily, a value between 0 and 1 indicates evidence for a dense structure.

\item \code{relative.complexity.sparse} The relative complexity under a sparse prior hypothesis, which is the
proportion of estimated included edges relative to the total possible edges
under the different hypotheses.

\item \code{relative.complexity.dense} The relative complexity under a dense prior hypothesis.

\item \code{relative.complexity.uniform} The relative complexity under a uniform prior hypothesis.

\item \code{no.hypotheses} The number of hypotheses that are computed in the analysis. At least the sparse,
dense and uniform are used, but sometimes additional bridge hypotheses have to be
computed to be able to determine the Bayes factor.
}
}
\description{
The function tests if a network is sparse (i.e., few edges in between nodes) or
dense (i.e., a lot of edges between nodes). It estimates
the network model of a given data set under the hypothesis
that it is sparse and that it is dense, and computes th Bayes factor.
}
\examples{
\donttest{
library(easybgm)
library(bgms)

data <- na.omit(Wenchuan)

# Fitting the Wenchuan PTSD data

fit <- sparse_or_dense(data, type = "ordinal",
                iter = 1000 # for demonstration only (> 5e4 recommended)
                )
}  
             
}
