% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/EnsSprErr.R
\name{EnsSprErr}
\alias{EnsSprErr}
\title{Spread to Error Ratio}
\usage{
EnsSprErr(ens, obs)
}
\arguments{
\item{ens}{n x k matrix of n forecasts for k ensemble members}

\item{obs}{vector with n verifying observations}
}
\description{
Computes the spread to error ratio (SPR) for probabilistic forecasts - not
unlike the functions in SpecsVerification. SPR > 1 indicates overdispersion
(underconfidence), whereas SPR < indicates overconfidence in the forecasts.
}
\details{
Here we define the spread-error rate as the square root of the ratio
of mean ensemble variance to the mean squared error of the ensemble mean with
the verifying observations
}
\examples{
tm <- toymodel()
EnsSprErr(tm$fcst, tm$obs)

## compute spread to error ratio using veriApply
veriApply('EnsSprErr', fcst=tm$fcst, obs=tm$obs)
}
\seealso{
\code{\link{veriApply}}, \code{\link{FairSprErr}}
}

