% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/easyDifferentialGeneCoexpression.r
\name{easyDifferentialGeneCoexpression}
\alias{easyDifferentialGeneCoexpression}
\title{Function that computes the differential coexpression of a list of probesets in a specific dataset and returns the most significant pairs}
\usage{
easyDifferentialGeneCoexpression(
  list_of_probesets_to_select,
  GSE_code,
  featureNameToDiscriminateConditions,
  firstConditionName,
  secondConditionName,
  batchCorrection = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{list_of_probesets_to_select}{list of probesets for which the differential coexpression should be computed}

\item{GSE_code}{GEO accession code of the dataset to analyze}

\item{featureNameToDiscriminateConditions}{name of the feature of the dataset that contains the two conditions to investigate}

\item{firstConditionName}{name of the first condition in the feature to discriminate (for example, "healthy")}

\item{secondConditionName}{name of the second condition in the feature to discriminate (for example, "cancer")}

\item{batchCorrection}{says if the script should perform the batch correction with limma::removeBatchEffect() or not}

\item{verbose}{prints all the intermediate message to standard output or not}
}
\value{
a dataframe containing the significantly differentially co-expressed pairs of genes
}
\description{
Function that computes the differential coexpression of a list of probesets in a specific dataset and returns the most significant pairs
}
\examples{

probesetList <- c("200738_s_at", "217356_s_at", "206686_at")
verboseFlag <- "TRUE"
batchCorrection <- "TRUE"
signDiffCoexpressGenePairs <- easyDifferentialGeneCoexpression(probesetList, 
"GSE3268", "description", "Normal", "Tumor", verboseFlag)
}
