% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pointCloudAnalysis3D.R
\name{voxelCount}
\alias{voxelCount}
\title{Apply voxel counting on a point cloud}
\usage{
voxelCount(points, extent, xyRes, zRes = xyRes, zMin, zMax,
  standartize = FALSE, verbose = FALSE)
}
\arguments{
\item{points}{a x, y, z data.frame}

\item{extent}{a raster extent object of the extent to create the rasters}

\item{xyRes}{resolution in the ground plane of the created rasters}

\item{zRes}{resolution in the z axis (by default \code{zRes = xyRes})}

\item{zMin}{minimum z value}

\item{zMax}{maximum height value}

\item{standartize}{logical: standartize the values?}

\item{verbose}{logical: print currently processed height band in raster stack?}
}
\value{
A \code{rasterStack} object, representing the 3–D voxel cube.
}
\description{
A \code{rasterStack} object is created, representing the 3–D voxel cube.
The z axis is sliced into regular sections between the maximum and minimum value.
For every height slice a raster with points per cell counts is created. Additionally
the voxels can be standartized between 0 and 1.
}
\examples{
voxelCount(niclas, raster::extent(dem), 100, 100, 1000, 1400, standartize = TRUE)
}
