% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dynrModel.R
\name{dynr.model}
\alias{dynr.model}
\title{Create a dynrModel object for parameter estimation (cooking dynr) using \code{\link{dynr.cook}}}
\usage{
dynr.model(dynamics, measurement, noise, initial, data, ..., outfile)
}
\arguments{
\item{dynamics}{a dynrDynamics object prepared with \code{\link{prep.formulaDynamics}}
or \code{\link{prep.matrixDynamics}}}

\item{measurement}{a dynrMeasurement object prepared with \code{\link{prep.loadings}}
or \code{\link{prep.measurement}}}

\item{noise}{a dynrNoise object prepared with \code{\link{prep.noise}}}

\item{initial}{a dynrInitial object prepared with \code{\link{prep.initial}}}

\item{data}{a dynrData object made with \code{\link{dynr.data}}}

\item{...}{additional arguments specifying other dynrRecipe objects. Argument regimes is for
a dynrRegimes object prepared with \code{\link{prep.regimes}} and argument transform is for
a dynrTrans object prepared with \code{\link{prep.tfun}}.}

\item{outfile}{a character string of the name of the output C script of model functions to be compiled
for parameter estimation.}
}
\description{
Create a dynrModel object for parameter estimation (cooking dynr) using \code{\link{dynr.cook}}
}
\examples{
#rsmod <- dynr.model(dynamics=recDyn, measurement=recMeas, noise=recNoise,
#    initial=recIni, regimes=recReg, data=dd, outfile="RSLinearDiscrete.c")
#For a full demo example, see:
#demo(RSLinearDiscrete , package="dynr")
}

