% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataDoc.R
\docType{data}
\name{PFAsim}
\alias{PFAsim}
\title{Simulated time series data of a multisubject process factor analysis}
\format{A data frame with 2,500 rows and 10 variables}
\usage{
data(PFAsim)
}
\description{
A multiple subject dataset simulated using a two factor process factor analysis model in discrete time
with 6 observed indicators for identifying two latent factors.
The variables are as follows:
}
\details{
\itemize{
  \item ID. Person ID variable (1 to 50 because there are 50 simulated people)
  \item Time. Time ID variable (1 to 50 because there are 50 time points)
  \item V1. Noisy observed variable 1
  \item V2. Noisy observed variable 2
  \item V3. Noisy observed variable 3
  \item V4. Noisy observed variable 4
  \item V5. Noisy observed variable 5
  \item V6. Noisy observed variable 6
  \item F1. True latent variable 1 scores
  \item F2. True latent variable 2 scores
}

Variables V1, V2, and V3 load on F1, whereas variables V4, V5, V6 load on F2.  The true values of the factor loadings are 1, 2, 1, 1, 2, and 1, respectively.  The true measurement error variance is 0.5 for all variables.  The true dynamic noise covariance has F1 with a variance of 2.77, F2 with a variance of 8.40, and their covariance is 2.47.  The across-time dynamics have autoregressive effects of 0.5 for both F1 and F2 with a cross-lagged effect from F1 to F2 at 0.4.  The cross-lagged effect from F2 to F1 is zero.  The true initial latent state distribution as mean zero and a diagonal covariance matrix with var(F1) = 2 and var(F2) = 1.  The generating model is the same for all individuals.
}
\keyword{datasets}

