% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_branch_feature_importance.R,
%   R/calculate_branching_point_feature_importance.R,
%   R/calculate_cell_feature_importance.R,
%   R/calculate_milestone_feature_importance.R,
%   R/calculate_overall_feature_importance.R,
%   R/calculate_waypoint_feature_importance.R
\name{calculate_branch_feature_importance}
\alias{calculate_branch_feature_importance}
\alias{calculate_branching_point_feature_importance}
\alias{calculate_cell_feature_importance}
\alias{calculate_milestone_feature_importance}
\alias{calculate_overall_feature_importance}
\alias{calculate_waypoint_feature_importance}
\title{Calculating feature importances across trajectories}
\usage{
calculate_branch_feature_importance(
  trajectory,
  expression_source = "expression",
  fi_method = fi_ranger_rf_lite(),
  verbose = FALSE
)

calculate_branching_point_feature_importance(
  trajectory,
  expression_source = "expression",
  milestones_oi = trajectory$milestone_ids,
  fi_method = fi_ranger_rf_lite(),
  verbose = FALSE
)

calculate_cell_feature_importance(
  trajectory,
  expression_source = "expression",
  fi_method = fi_ranger_rf_lite(),
  verbose = FALSE
)

calculate_milestone_feature_importance(
  trajectory,
  expression_source = "expression",
  milestones_oi = NULL,
  fi_method = fi_ranger_rf_lite(),
  verbose = FALSE
)

calculate_overall_feature_importance(
  trajectory,
  expression_source = "expression",
  fi_method = fi_ranger_rf_lite(),
  verbose = FALSE
)

calculate_waypoint_feature_importance(
  trajectory,
  expression_source = "expression",
  waypoints = NULL,
  fi_method = fi_ranger_rf_lite(),
  verbose = FALSE
)
}
\arguments{
\item{trajectory}{A trajectory object containing expression values and a trajectory.}

\item{expression_source}{The expression data matrix, with features as columns.
\itemize{
\item If a matrix is provided, it is used as is.
\item If a character is provided, \code{trajectory[[expression_source]]} should contain the matrix.
\item If a function is provided, that function will be called in order to obtain the expression (useful for lazy loading).
}}

\item{fi_method}{A feature importance method. Default: \code{fi_ranger_rf_lite()}. Check \code{?fi_methods} for a full list of available feature importance methods.}

\item{verbose}{Whether to print out extra information.}

\item{milestones_oi}{The milestone(s) for which to calculate feature importance}

\item{waypoints}{The waypoints, optional}
}
\value{
A data frame with two or more columns, \code{feature_id}, and \code{importance}. \code{feature_id} is a column in the trajectory expression matrix. Additional columns may be available depending on the function called.
}
\description{
Uses the feature importance measures of \code{\link[ranger]{ranger}} or \code{caret}.
\code{calculate_overall_feature_importance} calculates the importance for the whole trajectory,
\code{calculate_milestone_feature_importance} calculates it for individual milestones (e.g. branching points)
}
\examples{
library(dynwrap)
data(example_trajectory)

calculate_overall_feature_importance(example_trajectory)
}
