\name{disp.run}
\alias{disp.run}

\title{
Display results of a Dynamic TOPMODEL simulation run
}
\description{
Pretty display of simulation output plus rainfall and calculated evapotranspiration.
}
\usage{
disp.run(run, qmax = NA, legend = F, title = "", disp.par = def.disp.par(), ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{run}{
Results of simulation returned by run.proj
}
  \item{qmax}{
Maximum discharge shown (m). Useful for setting the y scale. If not supplied then set to (max value of all data)*1.25
}
  \item{legend}{
Whether to show a legend
}
  \item{title}{
A title for the graphic
}
  \item{disp.par}{
Display parameters
}
  \item{\dots}{
Any graphical parameters that can be passed to plot.zoo
}
}
\details{
Display a hydrograph generated by run.proj calculated evapotranspiration and observed rainfall and discharges.
}
\note{
Multiple columns of obsevation data will be plotted separately. All input and discharge data should be specific values given in m/hr
}
\author{
Peter Metcalfe <p.metcalfe@lancs.ac.uk>
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{run.proj}}
}
\examples{
 \dontrun{
  require(dynatopmod)
  # pre run simulation taken from Morland DTC. Manual calibration
  data(mor_demo_run)  
  disp.run(mor.demo.run, title="Morland Beck, Eden DTC. 10.1 sq.km")
  title(sub="Discharge data collected and rated by Eden DTC Team http://www.edendtc.org.uk.\n
  Rainfall from Casella TBR AWS. PE estimated. All data at 15 minute intervals", cex.sub=0.75)

  }
}
