% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readRadarFile.R
\name{readRadarFile}
\alias{readRadarFile}
\title{read binary radolan radar file}
\usage{
readRadarFile(binfile, na = NA, clutter = NA)
}
\arguments{
\item{binfile}{Name of a single binary file}

\item{na}{Value to be set for missing data (bit 14). DEFAULT: NA}

\item{clutter}{Value to be set for clutter data (bit 16). DEFAULT: NA}
}
\value{
Invisible list with \code{dat} (matrix) and \code{meta}
(list with elements from header, see Kompositformatbeschreibung)
}
\description{
Read a single binary DWD Radolan file. To be used in \code{rdwd}.\cr
  If any files ar not read correctly, please let me know. So far, tests have
  only been conducted for some files. Optimally, check the
  Kompositformatbeschreibung at \url{https://www.dwd.de/DE/leistungen/radolan/radolan.html}
  and let me know what needs to be changed.
  The meta-info is extracted with \code{\link{readHeader}} (not exported, but documented)\cr
  Binary bits are converted to decimal numbers with Fortran routines, see
  \url{https://github.com/brry/dwdradar/tree/master/src}.
  They are called via \code{\link{bin2num}} (not exported, but documented).
}
\examples{

f <- system.file("extdata/raa01_sf_2019-10-14_1950", package="dwdradar")
out <- readRadarFile(f)
out$meta

if(requireNamespace("raster", quietly=TRUE))
  raster::plot(raster::raster(out$dat))

# for more files, see the tests.
# for real-world usage, readDWD.binary / readDWD.radar in the rdwd package

}
\seealso{
real-world usage in \code{rdwd}: \url{https://bookdown.org/brry/rdwd/raster-data.html}
}
\author{
Maintained by Berry Boessenkool, \email{berry-b@gmx.de}, May + Oct 2019.\cr
  Original codebase by Henning Rust & Christoph Ritschel at FU Berlin
}
\keyword{binary}
\keyword{file}
