% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{var_n}
\alias{var_n}
\title{Sample Variance for Numeric Values}
\usage{
var_n(x)
}
\arguments{
\item{x}{Numeric vector.}
}
\value{
Numeric value.
}
\description{
Written in C++, this function should always run faster than 
\code{\link[stats]{var}} for numeric vectors. For integer vectors, 
\code{\link{var_i}} should run even faster.
}
\examples{
# In general, var_n is much faster than var.
x <- rnorm(1000)
all.equal(var(x), var_n(x))
benchmark(var(x), var_n(x), replications = 1000)

# For integer vectors, var_i should be even faster.
x <- rpois(1000, lambda = 5)
all.equal(var(x), var_i(x))
benchmark(var(x), var_n(x), var_i(x), replications = 1000)

}
