% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{var_i}
\alias{var_i}
\title{Sample Variance for Integer Values}
\usage{
var_i(x)
}
\arguments{
\item{x}{Integer vector.}
}
\value{
Numeric value.
}
\description{
Written in C++, this function should always run faster than 
\code{\link[stats]{var}} for integer vectors. Not valid for non-integer 
input vectors.
}
\examples{
# For integer vectors, var_i is typically much faster than var.
x <- rpois(1000, lambda = 5)
all.equal(var(x), var_i(x))
benchmark(var(x), var_i(x), replications = 5000)

}
