% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{smashlevels}
\alias{smashlevels}
\title{Collapse levels of a factor}
\usage{
smashlevels(f, newlevels)
}
\arguments{
\item{f}{factor.}

\item{newlevels}{list. The names of \code{newlevels} are the new levels. Each list element is a list
of old levels in the factor \code{f} which should be combined into the new level}
}
\description{
Combines levels of a factor into new levels
}
\examples{
# create a factor with levels 30:60
age <- factor(sample(30:60, 200, replace=TRUE))
# combine 35-40 into a single level, 41-50 into a single level, and 51-60 into a single level
g <- smashlevels(age, list(`35-40` = 35:40, `41-50` = 41:50, `51-60` = 51:60))
table(g)
# If the syntax permits, the backticks can be avoided.
h <- smashlevels(age, list(young=30:34, pushing40 = 35:40, pushing50 = 41:50, fossilized = 51:120))
table(h)
}
