% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{mphdist}
\alias{mphdist}
\alias{mphdist.log}
\alias{mphmoments}
\alias{mphmoments.log}
\alias{mphcov}
\alias{mphmedian}
\alias{mphcov.log}
\title{Extract the mixed proportional hazard distribution}
\usage{
mphdist(pset)

mphdist.log(pset)

mphmoments(pset)

mphmoments.log(pset)

mphcov(pset)

mphmedian(pset)

mphcov.log(pset)
}
\arguments{
\item{pset}{a parameter set of class \code{"mphcrm.pset"}, typically
\code{opt[[1]]$par}, where \code{opt} is returned from \code{\link{mphcrm}}.
If given a list of results, extracts the
first in the list.}
}
\value{
A matrix.
}
\description{
Various functions for extracting the proportional hazard distribution.

\code{mphdist} extracts the hazard distribution.

\code{mphdist.log} extracts the log hazard distribution.

\code{mphmoments} returns the first and second moments of the hazard distribution.

\code{mphmoments.log} returns the first and second moments of the log hazard distribution.

\code{mphcov} returns the variance/covariance matrix of the hazard distribution.

\code{mphmedian} returns the medians of the hazard distribution.

\code{mphcov.log} returns the variance/covariance matrix of the log hazard distribution.
}
\examples{
# load a dataset and a precomputed fitted model
data(durdata)
best <- fit[[1]]
mphdist(best)
mphmoments(best)
mphcov.log(best)
}
