% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_write.R
\name{ddbs_write_vector}
\alias{ddbs_write_vector}
\title{Write an SF Object to a DuckDB Database}
\usage{
ddbs_write_vector(conn, data, name, overwrite = FALSE)
}
\arguments{
\item{conn}{a connection object to a DuckDB database}

\item{data}{a \code{sf} object to write to the DuckDB database, or a local file}

\item{name}{a character string of length one specifying the name of the table,
or a character string of length two specifying the schema and table names.}

\item{overwrite}{whether to overwrite the existing table if it exists}
}
\value{
TRUE (invisibly) for successful import
}
\description{
This function writes a Simple Features (SF) object into a DuckDB database as a new table.
The table is created in the specified schema of the DuckDB database.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
## load packages
library(duckdb)
library(duckspatial)
library(sf)

## connect to in memory database
conn <- dbConnect(duckdb::duckdb())

## install the spatial exntesion
ddbs_install(conn)
ddbs_load(conn)

## create random points
random_points <- data.frame(
  id = 1:5,
  x = runif(5, min = -180, max = 180),  # Random longitude values
  y = runif(5, min = -90, max = 90)     # Random latitude values
)

## convert to sf
sf_points <- st_as_sf(random_points, coords = c("x", "y"), crs = 4326)

## insert data into the database
ddbs_write_vector(conn, sf_points, "points")

## read data back into R
ddbs_read_vector(conn, "points", crs = 4326)

## disconnect from db
dbDisconnect(conn)
\dontshow{\}) # examplesIf}
}
