% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend-dbplyr__duckdb_connection.R
\name{backend-duckdb}
\alias{simulate_duckdb}
\alias{translate_duckdb}
\title{DuckDB SQL backend for dbplyr}
\usage{
simulate_duckdb(...)

translate_duckdb(...)
}
\arguments{
\item{...}{Any parameters to be forwarded}
}
\description{
This is a SQL backend for dbplyr tailored to take into account DuckDB's
possibilities. This mainly follows the backend for PostgreSQL, but
contains more mapped functions.
}
\examples{
library(dplyr, warn.conflicts = FALSE)
con <- DBI::dbConnect(duckdb::duckdb(), path = ":memory:")

x <- tibble(txt = c("why", "video", "cross", "extra", "deal", "authority"))
dbx <- copy_to(con, x, overwrite = TRUE)

# x \%>\% filter(grepl("^.[hrx]", txt))
dbx \%>\% filter(grepl("^.[hrx]", txt))

# x \%>\% mutate(a = stringr::str_pad(txt, 10, side = "both", pad = ">"))
dbx \%>\% mutate(a = str_pad(txt, 10, side = "both", pad = ">"))

# x \%>\% mutate(a = stringr::str_replace_all(txt, "[aeiou]", "?"))
dbx \%>\% mutate(a = str_replace_all(txt, "[aeiou]", "?"))

DBI::dbDisconnect(con, shutdown = TRUE)
duckdb::duckdb_shutdown(duckdb::duckdb())
}
