% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_DTRSurv.R
\name{predict}
\alias{predict}
\alias{predict,DTRSurv-method}
\title{Prediction Method}
\usage{
\S4method{predict}{DTRSurv}(object, ..., newdata, stage = 1, findOptimal = TRUE)
}
\arguments{
\item{object}{A DTRSurv object. The object returned by a call to dtrSurv().}

\item{...}{Ignored. Used to require named inputs.}

\item{newdata}{NULL or a data.frame object. If NULL, this method retrieves
the estimated value for the training data. If a data.frame, the
value is estimated based on the data provided.}

\item{stage}{An integer object. The stage for which predictions are desired.}

\item{findOptimal}{A logical object. If TRUE, the value is estimated for
all treatment options and that leading to the maximum value for each
individual is used to estimate the value.}
}
\value{
a list object containing a matrix of the predicted survival function
  (survFunc), the estimated mean survuval (mean), and the estimated
  survival probability (if critical value is surv.mean or surv.prob)
}
\description{
Method to estimate the value for new data or to retrieve estimated value for
 training data
}
\examples{


dt <- data.frame("Y.1" = sample(1:100,100,TRUE), "Y.2" = sample(101:200,100,TRUE),
                 "D.1" = rbinom(100, 1, 0.9), "D.2" = rbinom(100,1,0.9),
                 "A.1" = rbinom(100, 1, 0.5), "A.2" = rbinom(100,1,0.5),
                 "X.1" = rnorm(100), "X.2" = rnorm(100))

# responses must be zero after event
evt <- dt[,"D.1"] == 1L
dt[evt, "Y.2"] <- 0.0

result <- dtrSurv(data = dt, 
                  txName = c("A.1", "A.2"), 
                  models = list(Surv(Y.1,D.1)~X.1+A.1, 
                                Surv(Y.2,D.2)~X.2+A.2+Y.1))

tt <- predict(object = result)
tt <- predict(object = result, stage = 1)
tt <- predict(object = result, findOptimal = FALSE)
tt <- predict(object = result, newdata = dt)
tt <- predict(object = result, newdata = dt, stage = 1)
tt <- predict(object = result, newdaata = dt, findOptimal = FALSE)
}
