% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addTobca.R
\name{addTobca}
\alias{addTobca}
\title{Add some elements of 0 mass to an existing basic chance assignment.}
\usage{
addTobca(x, tt, f)
}
\arguments{
\item{x}{A basic chance assignment (see \code{\link{bca}}).}

\item{tt}{A matrix constructed in a boolean style (0,1) or a boolean matrix. The number of columns of the matrix \code{tt} must match the number of columns of the \code{tt} matrix of \code{x} (see \code{\link{bca}}). Each row of the matrix identify a subset of the set of possible values.}

\item{f}{Deprecated. Old name for \code{tt} matrix.}
}
\value{
x The original basic chance assignment \code{x} augmented with the added subsets defined by \code{tt}.
}
\description{
Given a previously defined basic chance assignment (bca), the user may want to add some elements of the set of possible values or some subsets, even if they have zero mass value. This feature is useful, for example, to examine the measure of plausibility of these elements or subsets of zero mass value.
}
\examples{
 
y <- bca(tt = matrix(c(1,0,0,1,1,1),nrow=2, byrow = TRUE), 
m = c(0.6, 0.4),  cnames = c("a", "b", "c"), idvar = 1)
addTobca(y, matrix(c(0,1,0,0,0,1, 0,1,1), nrow = 3, byrow = TRUE))
x <- bca(tt = matrix(c(0,1,1,1,1,0,1,1,1),nrow=3, 
byrow = TRUE), m=c(0.2,0.5, 0.3), 
cnames = c("a", "b", "c"), idvar = 1)
xy <- dsrwon(x,y)
xy1 <- addTobca(nzdsr(xy), matrix(c(0,1,0,0,0,1), nrow = 2, byrow = TRUE))
xy1
# add all singletons to a bca
addTobca(x, tt = diag(rep(1, ncol(x$tt) ) )  ) 

}
\author{
Claude Boivin
}
