% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcaTrunc.R
\name{bcaTrunc}
\alias{bcaTrunc}
\title{Truncation of a basic chance assignment mass function}
\usage{
bcaTrunc(x, seuil, use_ssnames = FALSE)
}
\arguments{
\item{x}{A bca to truncate.}

\item{seuil}{A treshold value}

\item{use_ssnames}{Put TRUE to use ssnames parameter instead of description matrix. Default = FALSE.}
}
\value{
tr_x The bca object truncated.
}
\description{
When working with large frames of discernment, the bca resulting of repeated application of Dempster's Rule of Combination can become big. One way to handle this situation could be to group subsets whose mass is less than a small treshold value. The function \code{bcaTrunc} serves this purpose to reduce a large bca to its main elements.\cr
}
\examples{
x <- bca(tt = matrix(c(0,1,0,0, 
0,0,1,1,
1,1,0,0,
1,0,1,0,
0,1,1,0,
1,1,1,1),ncol=4, byrow = TRUE), m = c(0.2, 0.5, 0.06, 0.04, 0.03, 0.17),
cnames = c("a", "b", "c", "d"))
bcaPrint(x)
tr_x <- bcaTrunc(x, seuil = 0.1)
bcaPrint(tr_x)

}
\author{
Claude Boivin
}
