% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_multiplication.R
\name{h_mat_mult}
\alias{h_mat_mult}
\title{Multiply by H matrix}
\usage{
h_mat_mult(v, k, xd, di_weighting = FALSE, transpose = FALSE, inverse = FALSE)
}
\arguments{
\item{v}{Vector to be multiplied by H, the falling factorial basis matrix.}

\item{k}{Order for the falling factorial basis matrix. Must be >= 0.}

\item{xd}{Design points. Must be sorted in increasing order, and have length
at least \code{k+1}.}

\item{di_weighting}{Should "discrete integration weighting" be used?
Multiplication by such a weighted H gives discrete integrals at the
design points; see details for more information. The default is \code{FALSE}.}

\item{transpose}{Multiply by the transpose of H? The default is \code{FALSE}.}

\item{inverse}{Multiply by the inverse of H? The default is \code{FALSE}.}
}
\value{
Product of falling factorial basis matrix H and the input vector \code{v}.
}
\description{
Multiplies a given vector by H, the falling factorial basis matrix of a given
order, with respect to given design points.
}
\details{
The falling factorial basis matrix of order \eqn{k}, with respect to
design points \eqn{x_1 < \ldots < x_n}, is denoted \eqn{H^k_n}. Its entries
are defined as:
\deqn{
  (H^k_n)_{ij} = h^k_j(x_i),
  }
where \eqn{h^k_j} is the \eqn{j}th falling factorial basis function, as
defined in the help file for \code{\link[=h_mat]{h_mat()}}. The matrix \eqn{H^k_n} can be
constructed recursively as the product of \eqn{H^{k-1}_n} and a
diagonally-weighted cumulative sum matrix; see the help file for \code{\link[=h_mat]{h_mat()}},
or Section 6.3 of Tibshirani (2020). Therefore, multiplication by
\eqn{H^k_n} or by its transpose can be performed in \eqn{O(nk)} operations
based on iterated weighted cumulative sums. See Appendix D of Tibshirani
(2020) for details.

The option \code{di_weighting = TRUE} performs multiplication by \eqn{H^k_n
  Z^{k+1}_n} where \eqn{Z^{k+1}_n} is an \eqn{n \times n} diagonal matrix
whose first \eqn{k+1} diagonal entries of \eqn{Z^{k+1}_n} are 1 and last
\eqn{n-k-1} diagonal entries are \eqn{(x_{i+k+1} - x_i) / (k+1)}, \eqn{i =
  1,\ldots,n-k-1}. The connection to discrete integration is as follows:
multiplication of \eqn{v = f(x_{1:n})} by \eqn{H^k_n Z^{k+1}_n} gives order
\eqn{k+1} discrete integrals (note the increment in order of integration
here) of \eqn{f} at the points \eqn{x_{1:n}}:
\deqn{
  H^k_n Z^{k+1}_n v = (S^{k+1}_n f)(x_{1:n}).
  }

Lastly, the matrix \eqn{H^k_n} has a special \strong{inverse relationship} to the
extended discrete derivative matrix \eqn{B^{k+1}_n} of degree \eqn{k+1}; it
satisfies:
\deqn{
  H^k_n Z^{k+1}_n B^{k+1}_n = I_n,
  }
where \eqn{Z^{k+1}_n} is the \eqn{n \times n} diagonal matrix as described
above, and \eqn{I_n} is the \eqn{n \times n} identity matrix. This,
combined with the fact that the extended discrete derivative matrix has an
efficient recursive representation in terms of weighted differences, means
that multiplying by \eqn{(H^k_n)^{-1}} or its transpose can be performed in
\eqn{O(nk)} operations. See Section 6.2 and Appendix D of Tibshirani (2020)
for details.
}
\examples{
v = sort(runif(10))
as.vector(h_mat(2, 1:10) \%*\% v)
h_mat_mult(v, 2, 1:10) 
}
\references{
Tibshirani (2020), "Divided differences, falling factorials, and
discrete splines: Another look at trend filtering and related problems",
Section 6.2.
}
\seealso{
\code{\link[=discrete_integ]{discrete_integ()}} for discrete integration at arbitrary query
points, and \code{\link[=h_mat]{h_mat()}} for constructing the falling factorial basis matrix.
}
