% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.dsm.R
\name{predict.dsm}
\alias{predict.dsm}
\title{Predict from a fitted density surface model}
\usage{
\method{predict}{dsm}(object, newdata = NULL, off.set = NULL, type = "response", ...)
}
\arguments{
\item{object}{a fitted \code{\link{dsm}} object}

\item{newdata}{spatially referenced covariates e.g. altitude, depth,
distance to shore, etc. Covariates in the \code{data.frame} must have names
\emph{identical} to variable names used in fitting the model}

\item{off.set}{area of each of the cells in the prediction grid. Should be
in the same units as the segments/distances given to \code{dsm}. Replaces the
column in \code{newdata} called \code{off.set} if it is supplied. Ignored if \code{newdata}
is not supplied}

\item{type}{what scale should the results be on. The default is
\code{"response"}, see \code{\link[mgcv:predict.gam]{predict.gam}} for an explanation of
other options (usually not necessary)}

\item{\dots}{any other arguments passed to \code{\link[mgcv:predict.gam]{predict.gam}}}
}
\value{
predicted values on the response scale by default (unless \code{type} is
specified, in which case see \code{\link[mgcv:predict.gam]{predict.gam}}).
}
\description{
Make predictions of density or abundance outside (or inside) the covered
area.
}
\details{
If \code{newdata} is not supplied, predictions are made for the data that built
the model. Note that the order of the results will not necessarily be the
same as the \code{segdata} (segment data) \code{data.frame} that was supplied to
\code{\link{dsm}}.

The area \code{off.set} is used if that argument is supplied, otherwise it will
look for the areas in the column named \code{off.set} in the \code{newdata}. Either
way the link function (usually \code{log}) will be applied to the offsets, so
there is no need to log them before passing them to this function.
}
\seealso{
\code{\link[mgcv:predict.gam]{predict.gam}}, \code{\link{dsm.var.gam}},
\code{\link{dsm.var.prop}}
}
\author{
David L. Miller
}
