% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_pred_by_term.R
\name{plot_pred_by_term}
\alias{plot_pred_by_term}
\title{Spatially plot predictions per model term}
\usage{
plot_pred_by_term(dsm.obj, data, location_cov = c("x", "y"))
}
\arguments{
\item{dsm.obj}{fitted \code{dsm} object}

\item{data}{data to use to plot (often the same as the precition grid), data should also include \code{width} and \code{height} columns for plotting}

\item{location_cov}{which covariates to plot by (usually 2, spatial covariates, by default \code{=c("x","y")}}
}
\value{
a \code{ggplot2} plot
}
\description{
Plot the effect of each smooth in the model spatially. For each term in the model, plot its effect in space. Plots are made on the same scale, so that the relative influence of each smooth can be seen.
}
\examples{
\dontrun{
library(Distance)
library(dsm)

# load the Gulf of Mexico dolphin data and fit a model
data(mexdolphins)
hr.model <- ds(distdata, max(distdata$distance),
               key = "hr", adjustment = NULL)
mod1 <- dsm(count~s(x,y) + s(depth), hr.model, segdata, obsdata)

preddata$width <- preddata$height <- sqrt(preddata$area)

# make the plot
plot_pred_by_term(mod1, preddata, c("x","y"))

# better plot would be
# library(viridis)
# plot_pred_by_term(mod1, preddata, c("x","y")) + scale_fill_viridis()
}
}
\author{
David L Miller (idea taken from \code{inlabru})
}
