\name{estVARXls}
\alias{estVARXls}

\title{Estimate a VAR TSmodel}
\description{Estimate a VAR TSmodel with (optionally) an exogenous input and 
(optionally) a trend.
}
\usage{
    estVARXls(data, subtract.means=FALSE, re.add.means=TRUE, standardize=FALSE, 
     unstandardize=TRUE, max.lag=NULL, trend=FALSE, lag.weight=1.0, warn=TRUE) 
}
\arguments{
    \item{data}{A TSdata object.}
    \item{subtract.means}{If TRUE subtract the means from the data before estimation.}
    \item{re.add.means}{
    If TRUE and subtract.means is TRUE then the mean is added back to the data and 
    the model is adjusted for the non-zero mean data when returned.}
    \item{standardize}{
    If TRUE divide each series by its sample standard 
    deviation before estimation.
    Note that the mean is not subtracted unless subtract.means is TRUE.}
    \item{unstandardize}{
    If TRUE and standardize is TRUE then the returned 
    model is adjusted to correspond to the original data.}
    \item{trend}{If TRUE a trend is estimated.}
    \item{max.lag}{Number of lags to be used.}
    \item{lag.weight}{
    Weight between 0 and 1 to be applied to lagged data. 
    Lower weights mean lagged data is less important (more noisy).}
    \item{warn}{
    If TRUE a warning message is issued when missing data (NA) is
    detected and the model predictions are reconstructed from the lsfit residuals.}
}
\value{A TSestModel object containing a TSmodel object which is a VAR model.}
\details{
A VAR model is fitted by least squares regression using lsfit. The
argument max.lag determines the number of lags. If it is not specified then
six lags are used. This is an exceedingly naive approach, so the max.lag
argument really should be specified (or see \code{bft} for a more complete
approach to model selection.)
If a trend is not
estimated the function estVARXar may be preferred. Missing data is
allowed in lsfit, but not (yet) by ARMA which generates the model
predictions, etc., based on the estimated model and the data. (This is
done to ensure the result is consistent with other estimation
techniques.) In the case of missing data ARMA is not used and the model
predictions, etc., are generated by adding the data and the lsfit
residual. This is slightly different from using ARMA, especially with
respect to initial conditions.
}
\references{
    Gilbert, P. D. (1993) State space and ARMA models: An overview of
    the equivalence. Working paper 93-4, Bank of Canada. Available at \url{http://www.bankofcanada.ca/1993/03/publications/research/working-paper-199/}

    Gilbert, P. D. (1995) Combining VAR Estimation and State Space 
    Model Reduction for Simple Good Predictions. \emph{J. of Forecasting: 
    Special Issue on VAR Modelling.} \bold{14}:229--250.
}
\seealso{
    \code{\link{estSSfromVARX}}
    \code{\link{estSSMittnik}}
    \code{\link{bft}}
    \code{\link{estVARXar}}
    \code{\link{estMaxLik}}
}
\examples{
    data("eg1.DSE.data.diff", package="dse")
    model <- estVARXls(eg1.DSE.data.diff)
}
\concept{DSE}
\keyword{ts}

