% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dsample.R
\name{dsample}
\alias{dsample}
\title{Random Samples Generation Through The Wang-Lee and Fu-Wang Algorithms}
\usage{
dsample(expr, rpmat, n = 1000, nk = 10000, wconst)
}
\arguments{
\item{expr}{expression}

\item{rpmat}{matrix containing random points for discretization}

\item{n}{a non-negative integer, the desired sample size.}

\item{nk}{a positive integer, the number of contours.  See \sQuote{Details}.}

\item{wconst}{a real number between 0 and 1.  See \sQuote{Details}.}
}
\value{
\code{sample.wl} gives the drawn sample as a \code{data.frame} with number of rows equals the specified size \code{n} and number of columns equals \code{ncol(x)-1}.
}
\description{
\code{sample.wl} generates a sample of specified size \code{n} from the target density funciton (up to a normalizing constant) based on the Wang-Lee algorithm
}
\details{
\code{X} has the number of rows equals to the number of discrete base points. In each row, the first element contians the funcitonal value of the target density and the rest elements are the coordinates at which the density is evaluated.
\code{wconst} is a constant for adjusting the volumn of the last contour.
}
\examples{
## The following example is taken from West (1993, page 414).
## West, M. (1993). Approximating posterior distributions by mixture.
##   Journal of the Royal Statistical Society - B, 55, 409-422.

expr <- expression((x1*(1-x2))^5 * (x2*(1-x1))^3 * (1-x1*(1-x2)-x2*(1-x1))^37)
sets <- list(x1=runif(1e5), x2=runif(1e5))
smp <- dsample(expr=expr, rpmat=sets, nk=1e4, n=1e3)

##
## More accurate results can be achieved by increasing the number
## of dicretization points and the number of contours.
}
\author{
Chel Hee Lee \email{chl948@mail.usask.ca}, Liqun Wang \email{liqun.wang@umanitoba.ca}
}
\references{
Wang, L. and Lee, C.H. (2014). Discretization-based direct random sample generation. Computational Statistics and Data Analysis, 71, 1001-1010.
Lee, C.H. (2009). Efficient Monte Carlo Random Sample Generation through Discretization, MSc thesis, Department of Satistics, University of Manitoba, Canada
Wang, L. and Fu, J. (2007). A practical sampling approach for a bayesian mixture model with unknown number of components. Statistical Papers, 48(4):631-653.
Fu, J. C. and Wang, L. (2002). A random-discretization based Monte Carlo sampling method and its application. Methodology and Computing in Applied Probability, 4, 5-25.
}
\keyword{discretization}
\keyword{sampling,}

