% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop31.R
\name{drop31}
\alias{drop31}
\title{Cutting spurious days from a series with 31 days a month.}
\usage{
drop31(x_ts, new_start = 335, new_end = 55)
}
\arguments{
\item{x_ts}{Input time series in the ts format}

\item{new_start}{New start date as day of the year. Value from 1 to 366.}

\item{new_end}{New end date as day of the year. Value from 1 to 366.}
}
\description{
Changing a series with 31 days a month to a series with the regular number of observations per month.
}
\details{
This function is used internally in dsa()
}
\examples{
x <- xts::xts(rnorm(1095, 100,1), seq.Date(as.Date("2009-01-01"), length.out=1095, by="days"))
a31 <- fill31(x)
a <- drop31(a31, 1, 365)
}
\author{
Daniel Ollech
}
