% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{posPsy_p_info}
\alias{posPsy_p_info}
\title{Positive Psychology: Participant data.}
\format{
A table with 295 cases (rows) and 6 variables (columns).
}
\source{
\strong{Articles}

\itemize{

\item Woodworth, R. J., O’Brien-Malone, A., Diamond, M. R., & Schüz, B. (2017). 
Web-based positive psychology interventions: A reexamination of effectiveness. 
\emph{Journal of Clinical Psychology}, \emph{73}(3), 218--232. 
doi: \code{10.1002/jclp.22328} 

\item Woodworth, R. J., O’Brien-Malone, A., Diamond, M. R. and Schüz, B. (2018). 
Data from, ‘Web-based positive psychology interventions: A reexamination of effectiveness’. 
\emph{Journal of Open Psychology Data}, \emph{6}(1). 
doi: \code{10.5334/jopd.35}
}

See \url{https://openpsychologydata.metajnl.com/articles/10.5334/jopd.35/} for details 
and \url{https://doi.org/10.6084/m9.figshare.1577563.v1} for original dataset. 

Additional references at \url{https://bookdown.org/hneth/ds4psy/B-1-datasets-pos.html}.
}
\usage{
posPsy_p_info
}
\description{
\code{posPsy_p_info} is a dataset containing details of 295 participants.
}
\details{
\describe{
  
  \item{id}{Participant ID.}
  
  \item{intervention}{Type of intervention: 
  3 positive psychology interventions (PPIs), plus 1 control condition: 
    1: "Using signature strengths", 
    2: "Three good things", 
    3: "Gratitude visit",  
    4: "Recording early memories" (control condition).}
    
  \item{sex}{Sex: 1 = female, 2 = male.}
  
  \item{age}{Age (in years).}
  
  \item{educ}{Education level: Scale from 1: less than 12 years, to 5: postgraduate degree.}
  
  \item{income}{Income: Scale from 1: below average, to 3: above average.} 
  
}

See codebook and references at \url{https://bookdown.org/hneth/ds4psy/B-1-datasets-pos.html}.
}
\seealso{
Other datasets: 
\code{\link{Bushisms}},
\code{\link{Trumpisms}},
\code{\link{countries}},
\code{\link{data_1}},
\code{\link{data_2}},
\code{\link{data_t1_de}},
\code{\link{data_t1_tab}},
\code{\link{data_t1}},
\code{\link{data_t2}},
\code{\link{data_t3}},
\code{\link{data_t4}},
\code{\link{dt_10}},
\code{\link{exp_num_dt}},
\code{\link{exp_wide}},
\code{\link{falsePosPsy_all}},
\code{\link{fame}},
\code{\link{flowery}},
\code{\link{fruits}},
\code{\link{outliers}},
\code{\link{pi_100k}},
\code{\link{posPsy_AHI_CESD}},
\code{\link{posPsy_long}},
\code{\link{posPsy_wide}},
\code{\link{t3}},
\code{\link{t4}},
\code{\link{t_1}},
\code{\link{t_2}},
\code{\link{t_3}},
\code{\link{t_4}},
\code{\link{table6}},
\code{\link{table7}},
\code{\link{table8}},
\code{\link{tb}}
}
\concept{datasets}
\keyword{datasets}
