% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute.R
\name{impute_qty}
\alias{impute_qty}
\title{Find implausible entries
Replace implausible or missing prescription quantities}
\usage{
impute_qty(data, method, where = is.na, group = "population", ...)
}
\arguments{
\item{data}{A data frame containing columns \code{prodcode}, \code{pracid}, \code{patid}}

\item{method}{Method for imputing the values. See details.}

\item{where}{Logical vector, or function applied to \code{variable} returning such a vector, indicating which elements to impute. Defaults to \code{\link[base:NA]{is.na}}}

\item{group}{Level of structure for imputation. Defaults to whole study population.}

\item{...}{Extra arguments, currently ignored}
}
\value{
A data frame of the same structure as \code{data}, with values imputed
}
\description{
Find implausible entries
Replace implausible or missing prescription quantities
}
\examples{
impute_qty(example_therapy, 'mean')

}
