% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute.R
\name{impute}
\alias{impute}
\title{Impute missing or implausible values}
\usage{
impute(
  data,
  variable,
  method = c("ignore", "mean", "median", "mode", "replace", "min", "max", "sum"),
  where = is.na,
  group,
  ...,
  replace_with = NA_real_
)
}
\arguments{
\item{data}{A data frame containing columns \code{prodcode}, \code{pracid}, \code{patid}}

\item{variable}{Unquoted name of the column in \code{dataset} to be imputed}

\item{method}{Method for imputing the values. See details.}

\item{where}{Logical vector, or function applied to \code{variable} returning such a vector, indicating which elements to impute. Defaults to \code{\link[base:NA]{is.na}}}

\item{group}{Level of structure for imputation. Defaults to whole study population.}

\item{...}{Extra arguments, currently ignored}

\item{replace_with}{if the method 'replace' is selected, which value should be inserted?

\itemize{
\item \code{ignore}. Do nothing, leaving input unchanged.
\item \code{mean}. Replace values with the mean by \code{group}
\item \code{median}. Replace values with the median by \code{group}
\item \code{mode}. Replace values with the most common value by \code{group}
\item \code{replace}. Replace values with \code{replace_with}, which defaults to \code{NA} (i.e. mark as missing)
\item \code{min}. Replace with minimum value.
\item \code{max}. Replace with maximum value.
\item \code{sum}. Replace with sum of values.
}}
}
\value{
A data frame of the same structure as \code{data}, with values imputed
}
\description{
This is a workhorse function used by \code{\link{impute_ndd}},
\code{\link{impute_qty}} and others.
}
\details{
The argument \code{where} indicates which values are to be imputed.
It can be specified as either a vector or as a function. Thus you can
specify, for example, \code{\link{is.na}} to impute all missing values, or
you can pass in a vector, if it depends on something else rather than just
the current values of the variable to imputed.
This design may change in future. In particular, if we want to impute
implausible values and impute missing values separately, it's important that
these steps are independent.
}
