% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logodds_fn.R
\name{estimate_ci_logodds}
\alias{estimate_ci_logodds}
\title{Compute confidence interval/s for the log-odds parameters}
\usage{
estimate_ci_logodds(
  logodds_est,
  cdf_est,
  out_form,
  covar,
  treat_prob_est,
  treat,
  treat_form,
  out,
  ci,
  alpha = 0.05,
  nboot,
  out_levels,
  out_model,
  ...
)
}
\arguments{
\item{logodds_est}{The point estimates for log-odds.}

\item{cdf_est}{A list of treatment-specific CDF estimates.}

\item{out_form}{The right-hand side of a regression formula for the working proportional 
odds model. NOTE: THIS FORMULA MUST NOT SUPPRESS THE INTERCEPT.}

\item{covar}{A \code{data.frame} containing the covariates to include in the working
proportional odds model.}

\item{treat_prob_est}{Estimated probability of treatments, output from call
to \code{estimate_treat_prob}.}

\item{treat}{A \code{numeric} vector containing treatment status. Should only assume 
a value 0 or 1.}

\item{treat_form}{The right-hand side of a regression formula for the working model of
treatment probability as a function of covariates}

\item{out}{A \code{numeric} vector containing the outcomes. Missing outcomes are 
allowed.}

\item{ci}{A vector of \code{characters} indicating which confidence intervals
should be computed (\code{"bca"} and/or \code{"wald"})}

\item{alpha}{Confidence intervals have nominal level 1-\code{alpha}.}

\item{nboot}{Number of bootstrap replicates used to compute bootstrap confidence
intervals.}

\item{out_levels}{A \code{numeric} vector containing all ordered levels of the 
outcome.}

\item{out_model}{Which R function should be used to fit the proportional odds 
model. Options are \code{"polr"} (from the \code{MASS} package), 
"vglm" (from the \code{VGAM} package), or \code{"clm"} (from the \code{ordinal} package).}

\item{...}{Other options (not currently used).}
}
\value{
List with \code{wald} and \code{bca}-estimated confidence intervals 
for the weighted mean parameters.
}
\description{
Compute confidence interval/s for the log-odds parameters
}
