% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_detect.R
\name{drop_detect}
\alias{drop_detect}
\title{Detecting Dropouts in Surveys}
\usage{
drop_detect(data, last_col = NULL)
}
\arguments{
\item{data}{A dataframe or tibble containing the survey data.}

\item{last_col}{The index position or column name of the last survey item. This is optional and is used when there are additional columns in the data frame that are not part of the survey questions you are interested in.}
}
\value{
A dataframe or tibble where each row corresponds to a row in the original dataset. It contains three columns:
\itemize{
\item \code{dropout}: A logical indicating whether a dropout was detected for this row.
\item \code{dropout_column}: If \code{dropout} is TRUE, the name of the column where the dropout occurred.
\item \code{dropout_index}: If \code{dropout} is TRUE, the index (column number) where the dropout occurred.
}
}
\description{
\code{drop_detect} function detects participants who have dropped out of a survey.
It identifies sequences of NA values up to the last survey question and pinpoints the column where the dropout occurred.
It also provides the index of that column, enabling targeted analysis of dropout patterns.
}
\examples{
# Basic usage
drop_detect(flying, "location_census_region")

}
\seealso{
See vignette for detailed workflows and practical examples.
}
