% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drda.R
\name{drda}
\alias{drda}
\title{Fit non-linear growth curves}
\usage{
drda(
  formula,
  data,
  subset,
  weights,
  na.action,
  mean_function = "logistic4",
  is_log = TRUE,
  lower_bound = NULL,
  upper_bound = NULL,
  start = NULL,
  max_iter = 10000
)
}
\arguments{
\item{formula}{an object of class \code{link[stats]{formula}} (or one that
can be coerced to that class): a symbolic description of the model to be
fitted. Currently supports only formulas of the type \code{y ~ x}.}

\item{data}{an optional data frame, list or environment (or object coercible
by \code{\link[base]{as.data.frame}} to a data frame) containing the
variables in the model. If not found in \code{data}, the variables are taken
from \code{environment(formula)}, typically the environment from which \code{drda}
is called.}

\item{subset}{an optional vector specifying a subset of observations to be
used in the fitting process.}

\item{weights}{an optional vector of weights to be used in the fitting
process. If provided, weighted least squares is used with weights \code{weights}
(that is, minimizing \code{sum(weights * residuals^2)}), otherwise ordinary
least squares is used.}

\item{na.action}{a function which indicates what should happen when the data
contain \code{NA}s. The default is set by the \code{na.action} setting of
\code{\link[base]{options}}, and is \code{\link[stats]{na.fail}} if that is
unset. The ‘factory-fresh’ default is \code{na.omit}. Another
possible value is \code{NULL}, no action. Value \code{na.exclude} can be useful.}

\item{mean_function}{the model to be fitted. See \code{details} for available
models.}

\item{is_log}{a logical value indicating whether the predictor variable \code{x}
is already log-transformed. Default to \code{TRUE}. Set to \code{FALSE} if \code{x} is
on its natural scale, i.e. strictly positive.}

\item{lower_bound}{numeric vector with the minimum admissible values of the
parameters. Use \code{-Inf} to specify an unbounded parameter.}

\item{upper_bound}{numeric vector with the maximum admissible values of the
parameters. Use \code{Inf} to specify an unbounded parameter.}

\item{start}{starting values for the parameters.}

\item{max_iter}{maximum number of iterations in the optimization algorithm.}
}
\value{
An object of class \code{drda} and \code{model_fit}, where \code{model} is the
chosen mean function. It is a list containing the following components:
\describe{
\item{converged}{boolean value assessing if the optimization algorithm
converged or not.}
\item{iterations}{total number of iterations performed by the
optimization algorithm}
\item{constrained}{boolean value set to \code{TRUE} if optimization was
constrained.}
\item{estimated}{boolean vector indicating which parameters were
estimated from the data.}
\item{coefficients}{maximum likelihood estimates of the model
parameters.}
\item{rss}{minimum value (found) of the residual sum of squares.}
\item{df.residuals}{residual degrees of freedom.}
\item{fitted.values}{fitted mean values.}
\item{residuals}{residuals, that is response minus fitted values.}
\item{weights}{(only for weighted fits) the specified weights.}
\item{mean_function}{model that was used for fitting.}
\item{n}{effective sample size.}
\item{sigma}{corrected maximum likelihood estimate of the standard
deviation.}
\item{loglik}{maximum value (found) of the log-likelihood function.}
\item{fisher.info}{observed Fisher information matrix evaluated at the
maximum likelihood estimator.}
\item{vcov}{approximate variance-covariance matrix of the model
parameters.}
\item{call}{the matched call.}
\item{terms}{the \code{\link[stats]{terms}} object used.}
\item{model}{the model frame used.}
\item{na.action}{(where relevant) information returned by
\code{\link[stats]{model.frame}} on the special handling of \code{NA}s.}
\item{is_log}{boolean value. It is \code{TRUE} if the predictor variable was
given on the log scale.}
}
}
\description{
Use the Newton's with a trust-region method to fit non-linear growth curves
to observed data.
}
\details{
\subsection{Available models}{
\subsection{Generalized logistic function}{

The most general model in this package is the generalized logistic function
selected by setting \code{mean_function = "logistic6"}. It is defined in this
package as the 6-parameter function

\code{alpha + (beta - alpha) / (xi + nu * exp(-eta * (x - phi)))^(1 / nu)}

where \code{eta != 0}, \code{nu > 0}, and \code{xi > 0}. Although \code{beta} can be any real
value, we use the convention \code{beta > alpha} to avoid identifiability
problems: when \code{beta < alpha} it is always possible to adjust the other
parameters to obtain the same exact curve. When \code{beta > alpha} and \code{eta > 0}
the curve is monotonically increasing. If \code{beta > alpha} and \code{eta < 0} the
curve is monotonically decreasing.

Parameter \code{alpha} represents the lower horizontal asymptote of the curve.
Parameter \code{beta} is related to the upper horizontal asymptote of the curve.
Parameter \code{eta} represents the steepness (growth rate) of the curve.
Parameter \code{phi} is related to the value of the function at \code{x = 0}.
Parameter \code{nu} affects near which asymptote maximum growth occurs.
Parameter \code{xi} affects the value of the upper asymptote.

\strong{Note}: the 6-parameter logistic function is non-identifiable from data and
should not be used in real applications. It is available only for theoretical
research convenience.
}

\subsection{5-parameter logistic function}{

The 5-parameter logistic function can be selected by choosing
\code{mean_function = "logistic5"}. The function is obtained by setting \code{xi = 1}
in the generalized logistic function, that is

\code{alpha + (beta - alpha) / (1 + nu * exp(-eta * (x - phi)))^(1 / nu)}

Parameter \code{alpha} represents the lower horizontal asymptote of the curve.
Parameter \code{beta} represents the upper horizontal asymptote of the curve.
Parameter \code{eta} represents the steepness (growth rate) of the curve.
Parameter \code{phi} is related to the value of the function at \code{x = 0}.
Parameter \code{nu} affects near which asymptote maximum growth occurs.
}

\subsection{4-parameter logistic function}{

The 4-parameter logistic function is the default model of \code{drda}. It can be
explicitly selected by choosing \code{mean_function = "logistic4"}. The function
is obtained by setting \code{xi = 1} and \code{nu = 1} in the generalized logistic
function, that is

\code{alpha + (beta - alpha) / (1 + exp(-eta * (x - phi)))}

Parameter \code{alpha} represents the lower horizontal asymptote of the curve.
Parameter \code{beta} represents the upper horizontal asymptote of the curve.
Parameter \code{eta} represents the steepness (growth rate) of the curve.
Parameter \code{phi} represents the \code{x} value at which the curve is equal to its
mid-point, i.e. \verb{f(phi; alpha, beta, eta, phi) = (alpha + beta) / 2}.
}

\subsection{2-parameter logistic function}{

The 2-parameter logistic function can be selected by choosing
\code{mean_function = "logistic2"}. The function is obtained by setting \code{xi = 1},
\code{nu = 1}, \code{beta = 1}, and \code{alpha = 0} in the generalized logistic function,
that is

\code{1 / (1 + exp(-eta * (x - phi)))}

Parameter \code{eta} represents the steepness (growth rate) of the curve.
Parameter \code{phi} represents the \code{x} value at which the curve is equal to its
mid-point, i.e. \verb{f(phi; eta, phi) = 1 / 2}.
}

\subsection{Gompertz function}{

The Gompertz function is the limit for \code{nu -> 0} of the 5-parameter logistic
function. It can be selected by choosing \code{mean_function = "gompertz"}. The
function is defined in this package as

\code{alpha + (beta - alpha) * exp(-exp(-eta * (x - phi)))}

where \code{eta != 0}.

Parameter \code{alpha} represents the lower horizontal asymptote of the curve.
Parameter \code{beta} represents the upper horizontal asymptote of the curve.
Parameter \code{eta} represents the steepness (growth rate) of the curve.
Parameter \code{phi} is related to the value of the function at \code{x = 0}.
}

\subsection{Constrained optimization}{

It is possible to search for the maximum likelihood estimates within
pre-specified interval regions. Since the upper horizontal asymptote \code{beta}
must be greater than the lower horizontal asymptote \code{alpha}, intervals are
adjusted to satisfy this constraint.

\emph{Note}: Hypothesis testing is not available for constrained estimates
because asymptotic approximations might not be valid
}

}
}
