% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamic.R
\name{read_trace}
\alias{read_trace}
\title{Read a trace of a dynamic target.
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#stable'><img src='figures/lifecycle-stable.svg' alt='Stable lifecycle'></a>}}{\strong{Stable}}}
\usage{
read_trace(
  trace,
  target,
  cache = drake::drake_cache(path = path),
  path = NULL,
  character_only = FALSE
)
}
\arguments{
\item{trace}{Character, name of the trace
you want to extract. Such trace names are declared
in the \code{.trace} argument of \code{map()}, \code{cross()} or \code{group()}.}

\item{target}{Symbol or character,
depending on the value of \code{character_only}.
\code{target} is T=the name of a dynamic target with one or more traces
defined using the \code{.trace} argument of dynamic \code{map()}, \code{cross()},
or \code{group()}.}

\item{cache}{drake cache. See \code{\link[=new_cache]{new_cache()}}.
If supplied, \code{path} is ignored.}

\item{path}{Path to a \code{drake} cache
(usually a hidden \verb{.drake/} folder) or \code{NULL}.}

\item{character_only}{Logical, whether \code{name} should be treated
as a character or a symbol
(just like \code{character.only} in \code{\link[=library]{library()}}).}
}
\value{
The dynamic trace of one target in another:
a vector of values from a grouping variable.
}
\description{
Read a target's dynamic trace from the cache.
Best used on its own outside a \code{drake} plan.
}
\details{
In dynamic branching, the trace keeps track
of how the sub-targets were generated.
It reminds us the values of grouping variables
that go with individual sub-targets.
}
\examples{
\dontrun{
isolate_example("demonstrate dynamic trace", {
plan <- drake_plan(
  w = LETTERS[seq_len(3)],
  x = letters[seq_len(2)],

  # The first trace lets us see the values of w
  # that go with the sub-targets of y.
  y = target(paste0(w, x), dynamic = cross(w, x, .trace = w)),

  # We can use the trace as a grouping variable for the next
  # group().
  w_tr = read_trace("w", y),

  # Now, we use the trace again to keep track of the
  # values of w corresponding to the sub-targets of z.
  z = target(
    paste0(y, collapse = "-"),
    dynamic = group(y, .by = w_tr, .trace = w_tr)
  )
)
make(plan)

# We can read the trace outside make().
# That way, we know which values of `w` correspond
# to the sub-targets of `y`.
readd(y)
read_trace("w", y)

# And we know which values of `w_tr` (and thus `w`)
# match up with the sub-targets of `y`.
readd(z)
read_trace("w_tr", z)
})
}
}
\seealso{
\code{\link[=get_trace]{get_trace()}}, \code{\link[=subtargets]{subtargets()}}
}
