% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decorate_storr.R
\name{drake_tempfile}
\alias{drake_tempfile}
\title{drake tempfile
\lifecycle{experimental}}
\usage{
drake_tempfile(path = NULL, cache = drake::drake_cache(path = path))
}
\arguments{
\item{path}{Path to a \code{drake} cache
(usually a hidden \verb{.drake/} folder) or \code{NULL}.}

\item{cache}{drake cache. See \code{\link[=new_cache]{new_cache()}}.
If supplied, \code{path} is ignored.}
}
\description{
Create the path to a temporary file inside drake's cache.
}
\details{
This function is just like the \code{tempfile()} function in base R
except that the path points to a special location inside \code{drake}'s cache.
This ensures that if the file needs to be copied to
persistent storage in the cache, \code{drake} does not need to copy across
physical storage media. Example: the \code{"diskframe"} format. See the
"Formats" and "Columns" sections of the \code{\link[=drake_plan]{drake_plan()}} help file.
Unless you supply the cache or the path to the cache
(see \code{\link[=drake_cache]{drake_cache()}}) \code{drake} will assume the cache folder is named
\verb{.drake/} and it is located either in your working directory or an
ancestor of your working directory.
}
\examples{
cache <- new_cache(tempfile())
# No need to supply a cache if a .drake/ folder exists.
drake_tempfile(cache = cache)
drake_plan(
  x = target(
    as.disk.frame(large_data, outdir = drake_tempfile()),
    format = "diskframe"
  )
)
}
\seealso{
\code{\link[=drake_cache]{drake_cache()}}, \code{\link[=new_cache]{new_cache()}}
}
