% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_reduce.R
\name{map_plan}
\alias{map_plan}
\title{Create a plan that maps a function to a grid of arguments.}
\usage{
map_plan(args, fun, id = "id", character_only = FALSE, trace = FALSE)
}
\arguments{
\item{args}{a data frame (or better yet, a \code{tibble})
of function arguments to \code{fun}.
Here, the column names should be the names of the arguments
of \code{fun}, and each row of \code{args} corresponds to a
call to \code{fun}.}

\item{fun}{name of a function to apply the arguments
row-by-row. Supply a symbol if \code{character_only} is
\code{FALSE} and a character scalar otherwise.}

\item{id}{name of an optional column in \code{args}
giving the names of the targets. If not supplied,
target names will be generated automatically.
\code{id} should be a symbol if \code{character_only} is \code{FALSE}
and a character scalar otherwise.}

\item{character_only}{logical, whether to interpret
the \code{fun} and \code{id} arguments as character scalars or symbols.}

\item{trace}{logical, whether to append the columns of \code{args}
to the output workflow plan data frame. The added columns
help "trace back" the original settings that went into building
each target. Similar to the \code{trace} argument of \code{\link[=evaluate_plan]{evaluate_plan()}}.}
}
\value{
A workflow plan data frame.
}
\description{
\code{map_plan()} is like \code{base::Map()}:
it takes a function name and a grid of arguments, and
writes out all the commands calls to apply the function to
each row of arguments.
}
\examples{
# For the full tutorial, visit
# https://ropenscilabs.github.io/drake-manual/plans.html#map_plan.
my_model_fit <- function(x1, x2, data) {
  lm(as.formula(paste("mpg ~", x1, "+", x1)), data = data)
}
covariates <- setdiff(colnames(mtcars), "mpg")
args <- t(combn(covariates, 2))
colnames(args) <- c("x1", "x2")
args <- tibble::as_tibble(args)
args$data <- "mtcars"
args$data <- rlang::syms(args$data)
args$id <- paste0("fit_", args$x1, "_", args$x2)
args
plan <- map_plan(args, my_model_fit)
plan
# Consider `trace = TRUE` to include the columns in `args`
# in your plan.
map_plan(args, my_model_fit, trace = TRUE)
# And of course, you can execute the plan and
# inspect your results.
cache <- storr::storr_environment()
make(plan, verbose = FALSE, cache = cache)
readd(fit_cyl_disp, cache = cache)
}
\seealso{
\code{\link[=drake_plan]{drake_plan()}}, \code{\link[=reduce_by]{reduce_by()}}, \code{\link[=gather_by]{gather_by()}}, \code{\link[=reduce_plan]{reduce_plan()}}, \code{\link[=gather_plan]{gather_plan()}},
\code{\link[=evaluate_plan]{evaluate_plan()}}, \code{\link[=expand_plan]{expand_plan()}}
}
