% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sankey_drake_graph.R
\name{render_sankey_drake_graph}
\alias{render_sankey_drake_graph}
\title{Render a Sankey diagram from\code{\link[=drake_graph_info]{drake_graph_info()}}.}
\usage{
render_sankey_drake_graph(graph_info, file = character(0),
  selfcontained = FALSE, ...)
}
\arguments{
\item{graph_info}{list of data frames generated by
\code{\link[=drake_graph_info]{drake_graph_info()}}.
There should be 3 data frames: \code{nodes}, \code{edges},
and \code{legend_nodes}.}

\item{file}{Name of a file to save the graph.
If \code{NULL} or \code{character(0)}, no file is saved and
the graph is rendered and displayed within R.
If the file ends in a \code{.png}, \code{.jpg}, \code{.jpeg}, or \code{.pdf} extension,
then a static image will be saved. In this case,
the webshot package and PhantomJS are required:
\code{install.packages("webshot"); webshot::install_phantomjs()}.
If the file does not end in a \code{.png}, \code{.jpg}, \code{.jpeg}, or \code{.pdf}
extension, an HTML file will be saved, and you can open the
interactive graph using a web browser.}

\item{selfcontained}{logical, whether
to save the \code{file} as a self-contained
HTML file (with external resources base64 encoded) or a file with
external resources placed in an adjacent directory. If \code{TRUE},
pandoc is required.}

\item{...}{arguments passed to \code{networkD3::sankeyNetwork()}.}
}
\value{
A \code{visNetwork} graph.
}
\description{
This function is called inside
\code{\link[=sankey_drake_graph]{sankey_drake_graph()}}, which typical users
call more often. A legend is unfortunately unavailable
for the graph itself
(\url{https://github.com/christophergandrud/networkD3/issues/240})
but you can see what all the colors mean with
\code{visNetwork::visNetwork(drake::legend_nodes())}.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
load_mtcars_example() # Get the code with drake_example("mtcars").
# Instead of jumpting right to sankey_drake_graph(), get the data frames
# of nodes, edges, and legend nodes.
config <- drake_config(my_plan) # Internal configuration list
sankey_drake_graph(config) # Jump straight to the interactive graph.
# Show the legend separately.
visNetwork::visNetwork(nodes = drake::legend_nodes())
# Get the node and edge info that sankey_drake_graph() just plotted:
graph <- drake_graph_info(config)
# You can pass the data frames right to render_sankey_drake_graph()
# (as in sankey_drake_graph()) or you can create
# your own custom visNewtork graph.
render_sankey_drake_graph(graph, width = '100\%') # Width is passed to visNetwork.
# Optionally visualize clusters.
config$plan$large_data <- grepl("large", config$plan$target)
graph <- drake_graph_info(
  config, group = "large_data", clusters = c(TRUE, FALSE))
render_sankey_drake_graph(graph)
# You can even use clusters given to you for free in the `graph$nodes`
# data frame.
graph <- drake_graph_info(
  config, group = "status", clusters = "imported")
render_sankey_drake_graph(graph)
})
}
}
\seealso{
\code{\link[=sankey_drake_graph]{sankey_drake_graph()}}, \code{\link[=vis_drake_graph]{vis_drake_graph()}},
\code{\link[=drake_ggraph]{drake_ggraph()}}
}
