% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{get_cache}
\alias{get_cache}
\title{Get the drake cache, optionally searching up the file system.}
\usage{
get_cache(path = getwd(), search = TRUE,
  verbose = drake::default_verbose(), force = FALSE, fetch_cache = NULL)
}
\arguments{
\item{path}{Root directory of the drake project,
or if \code{search} is \code{TRUE}, either the
project root or a subdirectory of the project.
Ignored if a \code{cache} is supplied.}

\item{search}{logical. If \code{TRUE}, search parent directories
to find the nearest drake cache. Otherwise, look in the
current working directory only.
Ignored if a \code{cache} is supplied.}

\item{verbose}{logical or numeric, control printing to the console.
Use \code{pkgconfig} to set the default value of \code{verbose}
for your R session:
for example, \code{pkgconfig::set_config("drake::verbose" = 2)}.
\describe{
\item{0 or \code{FALSE}:}{print nothing.}
\item{1 or \code{TRUE}:}{print only targets to build.}
\item{2:}{in addition, print checks and cache info.}
\item{3:}{in addition, print any potentially missing items.}
\item{4:}{in addition, print imports. Full verbosity.}
}}

\item{force}{logical, whether to load the cache
despite any back compatibility issues with the
running version of drake.}

\item{fetch_cache}{character vector containing lines of code.
The purpose of this code is to fetch the \code{storr} cache
with a command like \code{storr_rds()} or \code{storr_dbi()},
but customized. This feature is experimental.}
}
\value{
A drake/storr cache in a folder called \code{.drake/},
if available. \code{NULL} otherwise.
}
\description{
Only works if the cache
is in a folder called \code{.drake/}.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
clean(destroy = TRUE)
# No cache is available.
get_cache() # NULL
load_basic_example() # Get the code with drake_example("basic").
make(my_plan) # Run the project, build the targets.
x <- get_cache() # Now, there is a cache.
# List the objects readable from the cache with readd().
x$list() # Or x$list(namespace = x$default_namespace)
})
}
}
\seealso{
\code{\link[=this_cache]{this_cache()}}, \code{\link[=new_cache]{new_cache()}},
\code{\link[=recover_cache]{recover_cache()}}, \code{\link[=config]{config()}}
}
