% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.R
\name{expand_plan}
\alias{expand_plan}
\title{Create replicates of targets.}
\usage{
expand_plan(plan, values = NULL)
}
\arguments{
\item{plan}{workflow plan data frame}

\item{values}{values to expand over. These will be appended to
the names of the new targets.}
}
\value{
An expanded workflow plan data frame (with replicated targets).
}
\description{
Duplicates the rows of a workflow plan data frame.
Prefixes are appended to the new target names
so targets still have unique names.
}
\examples{
# Create the part of the workflow plan for the datasets.
datasets <- drake_plan(
  small = simulate(5),
  large = simulate(50))
# Create replicates. If you want repeat targets,
# this is convenient.
expand_plan(datasets, values = c("rep1", "rep2", "rep3"))
}
