% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.R
\name{evaluate}
\alias{evaluate}
\title{Function \code{evaluate}}
\usage{
evaluate(plan, rules = NULL, wildcard = NULL, values = NULL,
  expand = TRUE)
}
\arguments{
\item{plan}{workflow plan data frame, similar to one produced by 
\code{link{plan}}}

\item{rules}{Named list with wildcards as names and vectors of 
replacements
as values. This is a way to evaluate multiple wildcards at once.
When not \code{NULL}, \code{rules} overrules \code{wildcard} and 
\code{values} if
not \code{NULL}.}

\item{wildcard}{character scalar denoting a wildcard placeholder}

\item{values}{vector of values to replace the wildcard 
in the drake instructions. Will be treated as a character vector.
Must be the same length as \code{plan$command} if \code{expand} is 
\code{TRUE}.}

\item{expand}{If \code{TRUE}, create a new rows in the workflow plan 
data frame
if multiple values are assigned to a single wildcard.
If \code{FALSE}, each occurence of the wildcard
is replaced with the next entry in the \code{values} vector, 
and the values are recycled.}
}
\value{
a workflow plan data frame with the wildcards evaluated
}
\description{
The commands in workflow plan data frames can have 
wildcard symbols that can stand for datasets, parameters, function 
arguments, etc. These wildcards can be evaluated over a set of 
possible values using \code{evaluate}.
}
\details{
Specify a single wildcard with the \code{wildcard}
and \code{values} arguments. In each command, the text in 
\code{wildcard} will be replaced by each value in \code{values}
in turn. Specify multiple wildcards ith the \code{rules} argument,
which overrules \code{wildcard} and \code{values} if 
not \code{NULL}. Here, \code{rules} should be a list with wildcards
as names and vectors of possible values as list elements.
}

