% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/loq_interval.R
\name{loq_interval}
\alias{loq_interval}
\title{Limits of quantifications estimation using interval method}
\usage{
loq_interval(x, subset.list = NULL, low.asymp = NULL, high.asymp = NULL,
    lowci = -Inf, highci = Inf, inter.method = "prediction", level = 0.95)
}
\arguments{
\item{x}{a \code{scluminex} object}

\item{subset.list}{list of analytes to estimate.
Default \code{NULL} (all analytes of the \code{scluminex} object)}

\item{low.asymp}{a number or character specifying the low
asymptote coefficient in the model.
Default \code{NULL} assumes LLOQ is the minimum value of
the concentration variable.}

\item{high.asymp}{a number or character specifying the high
asymptote coefficient.
Default \code{NULL} assumes HLOQ is the maximum value of the
concentration variable}

\item{lowci}{specify the lowest limit if exists for asymptote,
only applies if \code{low.asymp} equals \code{!NULL}.}

\item{highci}{specify the highest limit if exists for asymptote,
only applies if \code{high.asymp} equals \code{!NULL}.}

\item{inter.method}{interval method for estimating interval
LOQ ('prediction' or 'confidence')}

\item{level}{0 to 1 value specifying level of confidence. Default 0.95.}
}
\value{
Object of class \code{loq}.
}
\description{
Estimates the limits of quantification based on the asymptotes
coefficients.
}
\details{
If \code{low.asymp} (\code{high.asymp}) is specified
\code{lowci} (\code{highci}) must be \code{-Inf} (\code{Inf}).
When \code{lowci} (\code{highci}) is specified asymptote argument
must be \code{NULL}. When \code{low.asymp} and \code{lowci}
arguments are the default values,
the funtion assumes that LOQs are maximum and minimum values of data.
If \code{low.asymp} (\code{high.asymp}) or \code{lowci} (\code{highci})
arguments are specified but it is not possible to estimate the LOQ
(e.g., coefficient position is not well specified or estimated values
are beyond observed data) the function
estimates the LOQs based on maximum and minimum values.
When the background method is the constraint one, the LLOQ is the
concentration
value of the  log10(Background MFI mean) and low.asymp and lowci doesn't
apply.
}
\examples{
# Load data and estimate models
data(ecdata)
data(mfidata)

dat <- mfidata[mfidata$plate=="plate_1" & mfidata$analyte=="FGF",]

sdf <- data_selection(dat, ecdata)$plate_1

igmodels <- scluminex("plate_1",sdf$standard, sdf$background,
                lfct="SSl4",
                bkg="ignore",
                fmfi="mfi",
                verbose=FALSE)

# All default arguments
loq_interval(igmodels)

# Low asymptote coefficient of the model is 2
loq_interval(igmodels, low.asymp = 2)

# Low asymptote coefficient of the model is 2 and high is 3
loq_interval(igmodels, low.asymp = 2, high.asymp = 3)

# Fix to 2 and 3 the lower and upper asymptote
loq_interval(igmodels, lowci=2, highci=3)
}
\references{
Quinn CP, Semenova VA, Elie CM et al. (2002).
Specific, Sensitive, and Quantitative Enzyme-Linked Immunosorbent Assay
for Human Immunoglobulin G Antibodies to Anthrax Toxin
Protective Antigen.
\emph{Emerg Infect Dis} \bold{8 (10)},1103-10
}

