% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Clones.R
\name{makeAirrClone}
\alias{makeAirrClone}
\title{Generate a airrClone object for lineage construction}
\usage{
makeAirrClone(
  data,
  id = "sequence_id",
  seq = "sequence_alignment",
  germ = "germline_alignment_d_mask",
  v_call = "v_call",
  j_call = "j_call",
  junc_len = "junction_length",
  clone = "clone_id",
  mask_char = "N",
  max_mask = 0,
  pad_end = TRUE,
  text_fields = NULL,
  num_fields = NULL,
  seq_fields = NULL,
  add_count = TRUE,
  verbose = FALSE,
  collapse = TRUE,
  chain = "H",
  heavy = NULL,
  cell = "cell_id",
  locus = "locus",
  traits = NULL,
  mod3 = TRUE,
  randomize = TRUE,
  use_regions = TRUE,
  dup_singles = FALSE
)
}
\arguments{
\item{data}{data.frame containing the AIRR or Change-O data for a clone. See Details
for the list of required columns and their default values.}

\item{id}{name of the column containing sequence identifiers.}

\item{seq}{name of the column containing observed DNA sequences. All 
sequences in this column must be multiple aligned.}

\item{germ}{name of the column containing germline DNA sequences. All entries 
in this column should be identical for any given clone, and they
must be multiple aligned with the data in the \code{seq} column.}

\item{v_call}{name of the column containing V-segment allele assignments. All 
entries in this column should be identical to the gene level.}

\item{j_call}{name of the column containing J-segment allele assignments. All 
entries in this column should be identical to the gene level.}

\item{junc_len}{name of the column containing the length of the junction as a 
numeric value. All entries in this column should be identical 
for any given clone.}

\item{clone}{name of the column containing the identifier for the clone. All 
entries in this column should be identical.}

\item{mask_char}{character to use for masking and padding.}

\item{max_mask}{maximum number of characters to mask at the leading and trailing
sequence ends. If \code{NULL} then the upper masking bound will 
be automatically determined from the maximum number of observed 
leading or trailing Ns amongst all sequences. If set to \code{0} 
(default) then masking will not be performed.}

\item{pad_end}{if \code{TRUE} pad the end of each sequence with \code{mask_char}
to make every sequence the same length.}

\item{text_fields}{text annotation columns to retain and merge during duplicate removal.}

\item{num_fields}{numeric annotation columns to retain and sum during duplicate removal.}

\item{seq_fields}{sequence annotation columns to retain and collapse during duplicate 
removal. Note, this is distinct from the \code{seq} and \code{germ} 
arguments, which contain the primary sequence data for the clone
and should not be repeated in this argument.}

\item{add_count}{if \code{TRUE} add an additional annotation column called 
\code{COLLAPSE_COUNT} during duplicate removal that indicates the 
number of sequences that were collapsed.}

\item{verbose}{passed on to \code{collapseDuplicates}. If \code{TRUE}, report the 
numbers of input, discarded and output sequences; otherwise, process
sequences silently.}

\item{collapse}{collapse identical sequences?}

\item{chain}{if HL, include light chain information if available.}

\item{heavy}{name of heavy chain locus (default = "IGH")}

\item{cell}{name of the column containing cell assignment information}

\item{locus}{name of the column containing locus information}

\item{traits}{column ids to keep distinct during sequence collapse}

\item{mod3}{pad sequences to length mutliple three?}

\item{randomize}{randomize sequence order? Important if using PHYLIP}

\item{use_regions}{assign CDR/FWR regions?}

\item{dup_singles}{Duplicate sequences in singleton clones to include them as trees?}
}
\value{
A \link{airrClone} object containing the modified clone.
}
\description{
\code{makeAirrClone} takes a data.frame with AIRR or Change-O style columns as input and 
masks gap positions, masks ragged ends, removes duplicates sequences, and merges 
annotations associated with duplicate sequences. It returns a \code{airrClone} 
object which serves as input for lineage reconstruction.
}
\details{
The input data.frame (\code{data}) must columns for each of the required column name 
arguments: \code{id}, \code{seq}, \code{germ}, \code{v_call}, \code{j_call}, 
\code{junc_len}, and \code{clone}.  
Additional annotation columns specified in the \code{traits}, \code{text_fields}, 
\code{num_fields} or \code{seq_fields} arguments will be retained in the \code{data} 
slot of the return object, but are not required. These options differ by their behavior
among collapsed sequences. Identical sequences that differ by any values specified in the
\code{traits} option will be kept distinct. Identical sequences that differ only by
values in the \code{num_fields} option will be collapsed and the values of their 
\code{num_fields} columns will be added together. Similar behavior occurs with 
\code{text_fields} but the unique values will concatenated with a comma.

The default columns are IMGT-gapped sequence columns, but this is not a requirement. 
However, all sequences (both observed and germline) must be multiple aligned using
some scheme for both proper duplicate removal and lineage reconstruction. 

The value for the germline sequence, V-segment gene call, J-segment gene call, 
junction length, and clone identifier are determined from the first entry in the 
\code{germ}, \code{v_call}, \code{j_call}, \code{junc_len} and \code{clone} columns, 
respectively. For any given clone, each value in these columns should be identical.

To allow for cases where heavy and light chains are used, this function returns three
sequence columns for heavy chains (sequence), light chain (lsequence, empty if none 
available), and concatenated heavy+light chain (hlsequence). These contain sequences
in alignment with germline, lgermline, and hlgermline slots, respectively. The sequence
column used for build trees is specified in the \code{phylo_seq} slot. Importantly, 
this column is also the sequence column that also has uninformative columns removed
by \code{cleanAlignment}. It is highly likely we will change this system to a single 
\code{sequence} and \code{germline} slot in the near future.

The airrClone object also contains vectors \code{locus}, \code{region}, and 
\code{numbers}, which contain the locus, IMGT region, and IMGT number for each position
in the sequence column specified in \code{phylo_seq}. If IMGT-gapped sequences are not 
supplied, this will likely result in an error. Specify \code{use_regions=FALSE} if not
using IMGT-gapped sequences
}
\examples{
data(ExampleAirr)
airr_clone <- makeAirrClone(ExampleAirr[ExampleAirr$clone_id=="3184",])
}
\seealso{
Returns an \link{airrClone}. See \link{formatClones} to generate an 
ordered list of airrClone objects.
}
