% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/others.R
\name{predict.doremi}
\alias{predict.doremi}
\title{S3 method to predict signal values in a DOREMI object when entering a new excitation}
\usage{
\method{predict}{doremi}(object, ..., newdata, verbose = FALSE)
}
\arguments{
\item{object}{DOREMI object result of an analysis with the function remi}

\item{...}{Additional arguments inherited from generic predict method.}

\item{newdata}{includes a data frame containing three columns or more:

id (optional), indicating the individual identifier


time, containing the time values

excitation, being one or several columns containing the different excitations
used to estimate a new signal. As in the other methods for the predict function, the columns of newdata
must have the same names as those of the original object.}

\item{verbose}{Is a boolean that displays status messages of the function when set to 1.}
}
\value{
Returns a list containing the values of time, the values of the excitation and the predicted
values of the signal for the new excitation(s).
}
\description{
\code{predict.doremi} predicts signal values with a DOREMI object when providing a new excitation vector(s).
}
\examples{
myresult <- remi(data = cardio[id == 1],
                 input = "load",
                 time = "time",
                 signal = "hr",
                 embedding = 5)
#Copying cardio into a new data frame and modifying the excitation column
new_exc <- cardio[id == 1, !"id"]

et <- generate.excitation(amplitude = 100,
                                   nexc = 6,
                                   duration = 2,
                                   deltatf = 1,
                                   tmax = 49,
                                   minspacing = 2)
new_exc$load <- et$exc
new_exc$time <- et$t
predresult <- predict(myresult, newdata = new_exc)
plot(predresult)
}
