% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comments.R
\name{docx_extract_all_cmnts}
\alias{docx_extract_all_cmnts}
\title{Extract all comments from a Word document}
\usage{
docx_extract_all_cmnts(docx, include_text = FALSE)
}
\arguments{
\item{docx}{\code{docx} object read with \code{read_docx}}

\item{include_text}{if \code{TRUE} then the text associated with the comment will
also be included}
}
\value{
\code{data_frame} of comment id, author & text
}
\description{
Extract all comments from a Word document
}
\examples{
cmnts <- read_docx(system.file("examples/comments.docx", package="docxtractr"))
docx_cmnt_count(cmnts)
docx_describe_cmnts(cmnts)
docx_extract_all_cmnts(cmnts)
}
