% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{Defficiency}
\alias{Defficiency}
\title{D Efficiency}
\usage{
Defficiency(des, ref, mod, A = NULL, parNames = NULL)
}
\arguments{
\item{des}{a design.}

\item{ref}{a design, the reference.}

\item{mod}{a model.}

\item{A}{for \itemize{
\item D-efficiency: \code{NULL}
\item D_s-efficiency: a vector of names or indices, the subset of parameters of interest.
\item D_A-efficiency: either \itemize{
  \item directly: a matrix without row names.
  \item indirectly: a matrix with row names corresponding to the parameters.
  }
}}

\item{parNames}{a vector of names or indices, the subset of parameters to use.
Defaults to the parameters for which the Fisher information is available.}
}
\value{
\code{Defficiency} returns a single numeric.
}
\description{
\code{Defficiency} computes the D-, D_s or D_A-efficiency measure for a design with respect to a reference design.
}
\details{
Indices supplied to argument \code{A} correspond to the subset of parameters defined by argument \code{parNames}.

D efficiency is defined as
\deqn{\left(\frac{\left|M(\xi,\bar{\theta})\right|}{\left|M(\xi^{*},\bar{\theta})\right|}\right)^{1/n}}{( det(M(\xi, \theta)) / det(M(\xi*, \theta)) )**(1/n)}
and D_A efficiency as
\deqn{\left(\frac{\left|A^{T}M(\xi^{*},\bar{\boldsymbol{\theta}})^{-1}A\right|}{\left|A^{T}M(\xi,\bar{\boldsymbol{\theta}})^{-1}A\right|}\right)^{1/s}}{( det(t(A) \%*\% solve(M(\xi*, \theta)) \%*\% A) / det(t(A) \%*\% solve(M(\xi, \theta)) \%*\% A) )**(1/s)}
}
\examples{
## see examples for param

}
\seealso{
\code{\link{design}}, \code{\link{param}}
}

