% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redisWorker.R
\name{redisWorker}
\alias{redisWorker}
\title{Initialize a doRedis worker process.}
\usage{
redisWorker(
  queue,
  host = "localhost",
  port = 6379,
  iter = Inf,
  linger = 30,
  log = stderr(),
  connected = FALSE,
  password = NULL,
  loglevel = 0,
  timelimit = 0,
  ...
)
}
\arguments{
\item{queue}{work queue name or a vector of queue names}

\item{host}{Redis database host name or IP address}

\item{port}{Redis database port number}

\item{iter}{maximum number of tasks to process before exiting the worker loop}

\item{linger}{timeout in seconds after which the work queue is deleted that the worker terminates}

\item{log}{print messages to the specified file connection}

\item{connected}{set to \code{TRUE} to reuse an existing open connection to Redis, otherwise establish a new one}

\item{password}{optional Redis database password}

\item{loglevel}{set to > 0 to increase verbosity in the log}

\item{timelimit}{set to > 0 to specify a task time limit in seconds, after which worker processes are killed; beware that setting this value > 0 will terminate any R worker process if their task takes too long.}

\item{...}{Optional additional parameters passed to \code{\link{redisConnect}}}
}
\value{
NULL is invisibly returned.
}
\description{
The redisWorker function enrolls the current R session in one or
more doRedis worker pools specified by the work queue names. The worker
loop takes over the R session until the work queue(s) are deleted, after
which the worker loop exits after the \code{linger} period, or until
the worker has processed \code{iter} tasks.
Running workers also terminate after network activity with Redis remains
inactive for longer than the \code{timeout} period set in the \code{redisConnect}
function. That value defaults internally to 30 seconds in \code{redisWorker}.
You can increase it by including a {timeout=n} argument value.
}
\note{
The worker connection to Redis uses a TCP timeout value of 30 seconds by
default. That means that the worker will exit after about 30 seconds of inactivity.
If you want the worker to remain active for longer periods, set the \code{timeout}
option to a larger value.

Use the \code{linger} option to instruct the worker to linger for up to the indicated
number of seconds after the listening work queue has been removed. After at most that
interval, the worker will exit after removing the queue.
}
\seealso{
\code{\link{registerDoRedis}}, \code{\link{startLocalWorkers}}
}
