% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/by-splitBy.R
\name{by-split}
\alias{by-split}
\alias{split_by}
\alias{splitBy}
\alias{head.splitByData}
\alias{tail.splitByData}
\title{Split a data frame}
\usage{
split_by(data, formula, drop = TRUE)

splitBy(formula, data = parent.frame(), drop = TRUE)

\method{head}{splitByData}(x, n = 6L, ...)

\method{tail}{splitByData}(x, n = 6L, ...)
}
\arguments{
\item{data}{A data frame}

\item{formula}{Variables to split data frame by, as ‘as.quoted’
variables, a formula or character vector.}

\item{drop}{Logical indicating if levels that do not occur should
be dropped. Deprecated; levels that do not occur are ignored.}

\item{x}{An object.}

\item{n}{A single integer.  If positive or zero, size for the
resulting object: number of elements for a vector (including
lists), rows for a matrix or data frame or lines for a
function.  If negative, all but the ‘n’ last/first number of
elements of ‘x’.}

\item{...}{Arguments to be passed to or from other methods.}
}
\value{
A list of dataframes.
}
\description{
Split a dataframe according to the levels of variables
    in the dataframe. The variables to split by can be given as a
    formula or as a character vector.
}
\examples{

data(dietox, package="doBy")
splitBy(formula = ~Evit + Cu, data = dietox)
splitBy(formula = c("Evit", "Cu"), data = dietox)

splitBy(~Treatment + Type, data=CO2)
splitBy(c("Treatment", "Type"), data=CO2)

x <- splitBy(~Treatment, data=CO2)
head(x)
tail(x)
}
\seealso{
\code{\link{orderBy}}, \code{\link{summaryBy}},
    \code{\link{transformBy}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{utilities}
