% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dm_nest_tbl.R
\name{dm_pack_tbl}
\alias{dm_pack_tbl}
\title{dm_pack_tbl()}
\usage{
dm_pack_tbl(dm, parent_table, into = NULL)
}
\arguments{
\item{dm}{A dm.}

\item{parent_table}{A terminal table with one child table.}

\item{into}{The table to pack \code{parent_tables} into, optional as it can be guessed
from the foreign keys unambiguously but useful to be explicit.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{dm_pack_tbl()} converts a parent table to a packed column in its child
table.
The parent table should not have parent tables itself (i.e. it needs to be a
\emph{terminal parent table}).
}
\examples{
dm_packed <-
  dm_nycflights13() \%>\%
  dm_pack_tbl(planes)

dm_packed

dm_packed$flights

dm_packed$flights$planes
}
\seealso{
\code{\link[=dm_wrap_tbl]{dm_wrap_tbl()}}, \code{\link[=dm_unwrap_tbl]{dm_unwrap_tbl()}}, \code{\link[=dm_nest_tbl]{dm_nest_tbl()}}.
}
