% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foreign-keys.R
\name{dm_has_fk}
\alias{dm_has_fk}
\title{Check if foreign keys exists}
\usage{
dm_has_fk(dm, table, ref_table)
}
\arguments{
\item{dm}{A \code{dm} object.}

\item{table}{A table in the \code{dm}.}

\item{ref_table}{The table to be checked if it is referred to.}
}
\value{
A boolean value: \code{TRUE} if a reference from \code{table} to \code{ref_table} exists, \code{FALSE} otherwise.
}
\description{
\code{dm_has_fk()} checks if a foreign key reference exists between two tables in a \code{dm}.
}
\examples{
dm_nycflights13() \%>\%
  dm_has_fk(flights, airports)
dm_nycflights13() \%>\%
  dm_has_fk(airports, flights)
}
\seealso{
Other foreign key functions: 
\code{\link{dm_add_fk}()},
\code{\link{dm_enum_fk_candidates}()},
\code{\link{dm_get_all_fks}()},
\code{\link{dm_get_fk}()}
}
\concept{foreign key functions}
