% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{plot.transform}
\alias{plot.transform}
\title{Visualize Information for an "transform" Object}
\usage{
\method{plot}{transform}(x, typographic = TRUE, ...)
}
\arguments{
\item{x}{an object of class "transform", usually, a result of a call to transform().}

\item{typographic}{logical. Whether to apply focuses on typographic elements to ggplot2 visualization. 
The default is TRUE. if TRUE provides a base theme that focuses on typographic elements using hrbrthemes package.}

\item{...}{arguments to be passed to methods, such as graphical parameters (see par).}
}
\description{
Visualize two kinds of plot by attribute of `transform` class.
The transformation of a numerical variable is a density plot.
}
\examples{
# Standardization ------------------------------
creatinine_minmax <- transform(heartfailure$creatinine, method = "minmax")
creatinine_minmax
summary(creatinine_minmax)

plot(creatinine_minmax)

# Resolving Skewness  --------------------------
creatinine_log <- transform(heartfailure$creatinine, method = "log")
creatinine_log
summary(creatinine_log)

plot(creatinine_log)

plot(creatinine_log, typographic = FALSE)

}
\seealso{
\code{\link{transform}}, \code{\link{summary.transform}}.
}
