% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{summary.transform}
\alias{summary.transform}
\title{Summarizing transformation information}
\usage{
\method{summary}{transform}(object, ...)
}
\arguments{
\item{object}{an object of class "transform", usually, a result of a call to transform().}

\item{...}{further arguments passed to or from other methods.}
}
\description{
print and summary method for "transform" class.
}
\details{
summary.transform compares the distribution of data before and after data transformation.
}
\examples{
# Generate data for the example
carseats <- ISLR::Carseats
carseats[sample(seq(NROW(carseats)), 20), "Income"] <- NA
carseats[sample(seq(NROW(carseats)), 5), "Urban"] <- NA

# Standardization ------------------------------
advertising_minmax <- transform(carseats$Advertising, method = "minmax")
advertising_minmax
summary(advertising_minmax)
plot(advertising_minmax)

# Resolving Skewness  --------------------------
advertising_log <- transform(carseats$Advertising, method = "log")
advertising_log
summary(advertising_log)
plot(advertising_log)
}
\seealso{
\code{\link{transform}}, \code{\link{plot.transform}}.
}
