% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{plot.compare_category}
\alias{plot.compare_category}
\title{Visualize Information for an "compare_category" Object}
\usage{
\method{plot}{compare_category}(x, prompt = FALSE, na.rm = FALSE, ...)
}
\arguments{
\item{x}{an object of class "compare_category", usually, a result of a call to compare_category().}

\item{prompt}{logical. The default value is FALSE. If there are multiple visualizations to be output, if this argument value is TRUE, a prompt is output each time.}

\item{na.rm}{logical. Specifies whether to include NA when plotting mosaics plot. 
The default is FALSE, so plot NA.}

\item{...}{arguments to be passed to methods, such as graphical parameters (see par).
However, it does not support all parameters.}
}
\description{
Visualize mosaics plot by attribute of compare_category class.
}
\examples{
# Generate data for the example
carseats <- ISLR::Carseats
carseats[sample(seq(NROW(carseats)), 20), "Income"] <- NA
carseats[sample(seq(NROW(carseats)), 5), "Urban"] <- NA

# Compare the all categorical variables
all_var <- compare_category(carseats)

# Print compare class object
all_var
  
# Compare the two categorical variables
two_var <- compare_category(carseats, ShelveLoc, Urban)

# Print compare class object
two_var

# plot all pair of variables
plot(all_var)

# plot a pair of variables
plot(two_var)

# plot all pair of variables by prompt
plot(all_var, prompt = TRUE)

# plot a pair of variables
plot(two_var, las = 1)

}
\seealso{
\code{\link{compare_category}}, \code{\link{print.compare_category}}, \code{\link{summary.compare_category}}.
}
