% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/episode_group.R
\name{episode_group}
\alias{episode_group}
\alias{fixed_episodes}
\alias{rolling_episodes}
\title{Link events to chronological episodes.}
\usage{
episode_group(df, ..., episode_type = "fixed")

fixed_episodes(
  date,
  case_length = Inf,
  episode_unit = "days",
  to_s4 = TRUE,
  case_overlap_methods = 8,
  deduplicate = FALSE,
  display = "none",
  bi_direction = FALSE,
  recurrence_length = case_length,
  recurrence_overlap_methods = case_overlap_methods,
  include_index_period = TRUE,
  ...,
  overlap_methods = 8,
  overlap_method = 8,
  x
)

rolling_episodes(
  date,
  case_length = Inf,
  recurrence_length = case_length,
  episode_unit = "days",
  to_s4 = TRUE,
  case_overlap_methods = 8,
  recurrence_overlap_methods = case_overlap_methods,
  deduplicate = FALSE,
  display = "none",
  bi_direction = FALSE,
  include_index_period = TRUE,
  ...,
  overlap_methods = 8,
  overlap_method = 8,
  x
)
}
\arguments{
\item{df}{\code{[data.frame]}. Deprecated. One or more datasets appended together. See \code{Details}.}

\item{...}{Arguments passed to \code{episodes}.}

\item{episode_type}{\code{[character]}. Options are \code{"fixed"} (default), \code{"rolling"} or \code{"recursive"}. See \code{Details}.}

\item{date}{\code{[date|datetime|integer|\link{number_line}]}. Event date or period.}

\item{case_length}{\code{[integer|\link{number_line}]}. Duration from index event distinguishing one \code{"case"} from another.
This is the case window.}

\item{episode_unit}{\code{[character]}. Time units for \code{case_length} and \code{recurrence_length}. Options are "seconds", "minutes", "hours", "days" (default), "weeks", "months" or "years". See \code{diyar::episode_unit}.}

\item{to_s4}{\code{[logical]}. Deprecated. Output type - \code{\link[=epid-class]{epid}} (\code{TRUE}) or \code{data.frame} (\code{FALSE}).}

\item{case_overlap_methods}{\code{[character|integer]}. Methods of overlap considered when tracking duplicates of \code{"case"} events. See (\code{\link{overlaps}})}

\item{deduplicate}{\code{[logical]}. Deprecated. If \code{TRUE}, \code{"duplicate"} events are excluded from the \code{\link[=epid-class]{epid}}.}

\item{display}{\code{[character]}. The progress messages printed on screen. Options are; \code{"none"} (default), \code{"progress"}, \code{"stats"}, \code{"none_with_report"}, \code{"progress_with_report"} or \code{"stats_with_report"}.}

\item{bi_direction}{\code{[logical]}. Deprecated. If \code{TRUE}, \code{"duplicate"} events before and after the index event are tracked.}

\item{recurrence_length}{\code{[integer|\link{number_line}]}. Duration from the last \code{"duplicate"} event distinguishing a \code{"recurrent"} event from its index event. This is the recurrence window.}

\item{recurrence_overlap_methods}{\code{[character|integer]}. Methods of overlap considered when tracking duplicates of \code{"recurrent"} events. See (\code{\link{overlaps}})}

\item{include_index_period}{\code{[logical]}. Deprecated. If \code{TRUE}, events overlapping with the index event or period are linked even if they are outside the cut-off period.}

\item{overlap_methods}{\code{[character]}. Deprecated. Please use \code{case_overlap_methods} or \code{recurrence_overlap_methods}. Methods of overlap considered when tracking duplicate event. See (\code{\link{overlaps}})}

\item{overlap_method}{\code{[character]}. Deprecated. Please use \code{case_overlap_methods} or \code{recurrence_overlap_methods}. Methods of overlap considered when tracking event. All event are checked by the same set of \code{overlap_method}.}

\item{x}{\code{[date|datetime|integer|\link{number_line}]}. Deprecated. Record date or period. Please use \code{date}.}
}
\value{


\code{\link[=epid-class]{epid}}; \code{list}
}
\description{
Link dated events (records) which have similar attributes and occur within specified durations of each other.
Each set of linked records are assigned a unique identifier with relevant group-level information.
}
\details{
These functions are superseded. Moving forward, please use \code{\link{episodes}}.
}
\seealso{
\code{\link{episodes}}
}
